#!/usr/bin/env python


import sys, os, time
# need to manually do this for now. used when running as exe. crap, i know ...
sys.path.insert( 0, os.path.join(sys.prefix, "PyOpenGL-3.0.0a6-py2.5.egg") )
sys.path.insert( 0, os.path.join(sys.prefix, "setuptools-0.6c6-py2.5.egg") )



from mirra import main
from mirra import utilities

from tools import *
import scsynth, scosc
import sc



""" slicer. python interface connected to a supercollider scsyndef
http://www.ixi-software.net
License : GPL ->  Read doc/documentation.html
"""



class Slicer(main.App) :
    """ main appplication class, handles window contains events and graphics manager.
        Subclasses main.App and extends its public methods
    """

    def setUp(self) :
        """ set here the main window properties and characteristics
        """
        self.env = 'wx'
        self.caption = "Slicer" # window name
        self.size = 800, 600 # window size
        self.pos = 10, 10 # window top left location
        self.fullScreen = 0 # if fullScreen is on it will overwrite your pos and size to match the display's resolution
        self.frameRate = 15 # set refresh framerate

##        from mirra import export
##        export.pack('slicer.py', iconPath = 'data\\ixi_transp.ico', winconsole=0)

        self.readSetUpPrefs('prefs.txt')

        import gui # import the module that contains your custom frame
        self.frameClass = gui.MyFrame # set the class


######## open and save session files #############################
        
    def getSituation(self) : #, filename='slicer.txt') :
        """ returns current state from the application
        called from gui.py on saving a session file
        """
        data = { 'layers' : [], 'nodes' : [] }
        for b in self.boxList :
            data['layers'].append( (b.x/float(self.width), b.y/float(self.height), b.looper.mute) )
        data[ 'boxStep'] = self.boxStep
        data[ 'sndFile' ] = self.snd[ 'file' ] 
        data[ 'microtones' ] = self.microtones
        data[ 'vol' ] = self.vol
        data[ 'pitchLimits' ] = self.pitchLimits
        a = self.handles[0].x / float(self.width), self.handles[0].y / float(self.height)
        b = self.handles[1].x / float(self.width), self.handles[1].y / float(self.height)
        data[ 'nodes' ] = a , b

        data[ 'boxStep' ] = self.boxStep 
        data[ 'freedom' ] = self.freedom 
        data[ 'initRand' ] = self.initRand  
        data[ 'synthName' ] = self.synthName 
        
        return data


    def setSituation(self, data) :
        """ sets new application state from data taken from session file
        called from gui.py on open session file
        """
        # **** display changes in GUI menus as well!! *****
        self.soundFile = data[ 'sndFile' ]
        self.microtones = data[ 'microtones' ]  
        self.pitchLimits = data[ 'pitchLimits' ]
        self.boxStep = data[ 'boxStep' ]
        self.numOfLayers = len( data['layers'] )
        self.freedom = data[ 'freedom' ]
        self.initRand = data[ 'initRand' ]
        self.synthName = data[ 'synthName' ]

##        if sys.platform == 'darwin' and utilities.run_as_app() :
##            p = os.path.join( os.getcwd(), '../../../', 'sounds', self.soundFile )
##        else :
##            p = os.path.join( os.getcwd(), 'sounds', self.soundFile )

        p = os.path.join( utilities.get_cwd(), 'sounds', self.sndFile )

        self.loadSnd(p) # load snd in SC
        
        self.updatePitchLimits()
        self.drawZero() # update display

        self.vol = data[ 'vol' ] # !! just before updating volume in loopers, otherwise there is a burst of snd
        self.redoLoopers() 	 
        self.startLayers( self.numOfLayers )

        for box, d in zip(self.boxList, data['layers']) :
##            box.x, box.y, box.looper.mute = d # data['layers'][i] # set layers
            box.x = d[0] * self.width
            box.y = d[1] * self.height
            box.looper.mute = d[2] # data['layers'][i] # set l
            box.updateLooper() # update
            box.moveLabel() 
        
##        self.handles[0].loc, self.handles[1].loc = data[ 'nodes' ] # handles
        self.handles[0].loc = data[ 'nodes' ][0][0] * self.width, data[ 'nodes' ][0][1] * self.height
        self.handles[1].loc = data[ 'nodes' ][1][0] * self.width, data[ 'nodes' ][1][1] * self.height
        self.handles[0].updateDisplays() # update
        self.handles[1].updateDisplays() # this as well
        
##########################################################

            
## initialisation stuff ##########################################
        
    def start(self) :
        """ genral application startup
        define properties, read prefs, open audio engine and init audio, create all objects,
        init Wx interface.
        """
        if sys.platform == 'win32' : #on windows we need to use wx to trigger the SCsynth process and we need a reference to the parent
            scsynth.process.wxparent = self.window 

        # internal variables not set by user
        self.boxList = []
        self.handles = []
        self.displayList = []
        self.selected = 0
        self.joystate = [] # stores joysticks button combinations
        self.joyactions = { "inc" : 4,
                            "dec" : 5,
                            "fast": 6
                           } # maps keyboard buttons to actions
        self.loopers = []
        self.grain = 0 # lenght of layers
        self.sttime = 0 # starting time of first layer
        self.shift = 0 # shift inc delta
        self.pitch = 0 # snd pitch
        self.sndLenght = 0 # lenght of sound on PD in millisecs. Just for display purposes
        self.displayPitch = 0 # to display

        # GENERAL APP VARIABLES # MIGHT be owewriten by prefs file !!!!*****
        self.session = 0
        self.verbose = 0 # print error messages from SC
        self.spew = 0
        self.snd = {  'file' : '', 'bid' : 0 }
        self.boxStep = 0  # boxes automovement
##        self.autoBox = 0 # boxes automovement
        self.autoNodes = 0
        self.microtones = 1
##        self.sndName =  'sounds/tong.wav'
        self.sndFile = 'tong.wav'
        self.synthName = 'StereoPlayer' # in this case are the same
        self.vol = 0    # volume
        self.numOfLayers = 8 # default to 8
        self.samplerate = 44100 # snd card sample rate for supercollider server
        self.pitchLimits = [ 3.0, 1, -1 ] # top, middle of screen and bottom
        self.selection = 0
        self.initRand = 0
        self.freedom = { 'pitch' : 1, 'length' : 1, 'shift' : 1, 'start' : 1} # to lock them

        ## end declaring variables ############
        
        self.readOtherPrefs('prefs.txt') # reading general application preferences set by user, if any

        # trying to load session from prefs.txt
        if self.session != 0 and self.session != '' : # if a session was specified
##            if sys.platform == 'darwin' and utilities.run_as_app() :
##                self.window.frame.filename = os.path.join(os.getcwd(), '../../../', self.session)
##            else :
##                self.window.frame.filename = os.path.join(os.getcwd(), self.session)
            self.window.frame.filename = os.path.join( utilities.get_cwd(), self.session )
                
        self.launchAudio()
        self.statusbar = StatusBar(self.width*0.5, self.height-6, 1, self.width+2, 27,
                                   color=(0.85,0.85,0.85) )
        self.startLayers( self.numOfLayers )

        if self.initRand or self.window.frame.readFile() == -1 :
            self.randomSituation() # not session specified

        self.window.frame.startMenus() # set initial Wx menus status

        # done initialising ...



    def launchAudio(self) :
        """ starts audio system, registers OSC callbacks after
        starts sc module and loopers
        """
        sc.synthpath = os.path.join( os.getcwd(), 'data' )
        self.snd = { 'file': self.sndFile, 'bid': 0 }
        self.loopers = []

        sc.start( self.samplerate, self.verbose, self.spew )
            
        p = os.path.join( utilities.get_cwd(), 'sounds', self.sndFile )
        self.loadSnd( p ) 

        for b in xrange( 1000, 1000+self.numOfLayers ) : #buffers from 1000 upwards
             self.loopers.append( Looper( self.synthName, bus=b, amp=0, buffer=self.snd['bid'] ) )

        self.registerOSCCallbacks()

    ## OSC callbacks ####
    def registerOSCCallbacks(self) :
        sc.server.listener.register( '/tr', self.trigger ) # key, callback
        sc.server.listener.register( '/b_info', self.printAll )

    def printAll(self, msg) : print 'OSC msg received >> ', msg

    def trigger(self, msg) :
        try :
            self.displayList[msg[1]-1000].setplayhead( msg[3] )
        except IndexError :
            print 'list index out of range. at slicer.py trigger()'

##    def lenOSC(self, *msg) : # OSC in
##        self.sndLenght = msg[0][2]*44.1 # convert to millisecs. it was on samples
##        for d in self.displayList :
##            d.calcLimits()
##        for h in self.handles :
##            h.updateDisplays()
##            h.updateLabel()
            
        ################
            

    def startLayers(self, n) :
        """ instantiates basic graphical GUI objects
        """
        try : # kill all interface all instances
            print 'restarting interface'
            for o in self.boxList : o.end()
            for o in self.handles : o.end()
            for o in self.displayList : o.end()
            self.selection.end()
        except :
            print 'starting up, no interface yet'
        
        self.boxList = []
        self.handles = []
        self.displayList = []
        # prepare margins and distances for initialization block
        dw = self.width - 40 # width . 10 px margin on left and right
        dh = self.height / (n + (n / 5.5) ) # 65 # height.
        inbetween = self.height / ( ( n + (n/dh) ) * 10 ) # 5
        dx = self.width * 0.5 # x loc: centered on stage
        dy = self.height / (n * 2) # y loc for first one

        for z in range(self.numOfLayers) :
            c = utilities.randRGB()
            # displays
            display = Display(dx, dy, z, dw, dh, c)
            self.displayList.append(display) # displays, same color as correspondant box
            # small boxes
            x = z*20 -50 + self.width*0.5
            y = self.height*0.3
            box = MovingSmallBox(display, x, y, z+20, 9, 9, c) # z+20 to go on top of displays and other stuff
            self.boxList.append(box)
            
            display.mybox = box # has to remember whos related to
            dy += dh+inbetween # y loc for next one

        # one black handle
        x,y = -50 + self.width*0.5, self.height*0.5
        self.handles.append( BlackHandle( x,y, 11, 11,11, self.displayList, self.boxList, (0,0,0,1) ) )#(0,0.5,0)) # global handles
        # one white handle
        x,y = 50 +  self.width*0.5, self.height*0.5
        self.handles.append( WhiteHandle( x,y, 10, 11,11, self.displayList, self.boxList, (1,1,1,1) ) )#(0,0,0.5))

        # selection object
        self.selection = Selection(self.boxList) # selection object, it needs to know whos selectable
        self.selected = self.boxList[0] # I need to keep track of this, just initialising.

## END initialisation methods ###########################################################
        
    def randomSituation(self) :
        self.randomNodes()
        self.randomBoxes()

    def randomBoxes(self) :
        for b in self.boxList :
            b.loc = utilities.randPoint(1, 1, self.width, self.height)
            b.updateLooper()
            b.moveLabel() 
            
    def randomNodes(self) :
        for h in self.handles :
            h.loc = utilities.randPoint(1, 1, self.width, self.height)
            h.updateDisplays()

    def redoLoopers(self) :
        """ disables the ones not needed
        """
        for i, l in enumerate(self.loopers) : # current to max
            l.run( int( i < self.numOfLayers) ) # convert true/false to 1/0

    def drawZero(self) : # top, mid, bottom
        """ calcs the Y post of the 0 pitch line
        """
        if self.pitchLimits[0] > 0 and self.pitchLimits[2] < 0 : # zero in the screen
            if self.pitchLimits[1] < 0 : #is on top side
                v = (self.height*0.5) - ( (self.height*0.5) / (self.pitchLimits[0] + abs(self.pitchLimits[1]))  )  * abs(self.pitchLimits[1])
            else : #is on bottom???
                v = self.height - ( (self.height*0.5) / (self.pitchLimits[1] + abs(self.pitchLimits[2]))  )  * abs(self.pitchLimits[2])
            self.drawZeroY = v
        else :
            self.drawZeroY = -1 # out of screen

    def loadSnd(self, p) :
        sc.loader.unload(self.snd['bid'])
        self.snd['file'] = os.path.basename(p) # the file name
        self.snd['bid'] = sc.loader.load( p, b_query=1 ) # load sound buffer and store buffer's server id 
        time.sleep(0.1) # wait to load
        self.swapSndBid(self.snd['bid'])

    def swapSndPath(self, path) : # from wx menus
        for l in self.loopers : l.buffer = path

    def swapSndBid(self, bid) :
        for l in self.loopers : l.buffer = bid
        
    def end(self) :
        for l in self.loopers: l.free() # kill the sc loopers
        sc.loader.unload( self.snd['bid'] )
        sc.server.quit()

    def step(self) :
        self.statusbar.text = 'snd: %s | pitch: %s | length: %i | shift: %i | start: %i | vol: %s' % (self.snd['file'], self.pitch,self.grain,self.shift, self.sttime,self.vol )

##        try :
##            import livecode
##        except :
##            pass # 

    def render(self, e) :
        if self.drawZeroY : # drawing O pitch line
            glPushMatrix()
            glTranslatef(self.width2, self.drawZeroY, -999) # translate to GL loc ppint

            glEnable(GL_LINE_STIPPLE)
            glLineStipple(1, 0xF0F0)

            glLineWidth(1)

            glBegin(GL_LINES)
            glVertex2f(-self.width2, 0)
            glVertex2f(self.width2, 0) 
            glEnd()

            glDisable(GL_LINE_STIPPLE)
            
            glPopMatrix()

    def setVol(self, n) :
        self.__vol = n
        for b in self.boxList : b.updateLooper() #; print b.looper.amp
    def getVol(self) : return self.__vol
    vol = property(getVol, setVol)

    def setPitchL(self, l) :
        n = self.size[1]*0.5 # half the height of the window
        self.__pitchLimits = l # items 0,1,2 (top, midd, bottom)
        self.__pitchLimits.append( (l[0] - l[1]) / n) # sub 3
        self.__pitchLimits.append( (l[1] - l[2]) / n) # sub 4
        self.drawZero() # try draw line displaying 0 crossing
    def getPitchL(self) : return self.__pitchLimits
    pitchLimits = property(getPitchL, setPitchL)

    def updatePitchLimits(self) : self.handles[0].updateDisplays()

    def updateBoxDelta(self) :
        for b in self.boxList :
            b.delta = b.calcDelta()
            b.updateLooper()


     # joystick and mouse stuff ###########
        
    def mouseDown(self,x,y) : self.selection.select(x,y)
    def mouseUp(self,x,y) : self.selection.stop()

    def keyDown(self,key) :
        if key == 32: # space key to switch mouse visibility
            self.mouseVisible = not self.mouseVisible

    def joyHatMotion(self, joystick, index, value) :
        if self.joyactions['fast'] in self.joystate :
            self.selected.delta = value[0]*3, - value[1]*3
        else:
            self.selected.delta = value[0], - value[1]

    def joyButtonDown(self, joystick, button) :
        # joyactions = {"inc": 4, "dec":5, "fast": 6} # maps keyboard buttons to actions
        if not button in self.joystate : # keep track of buttons being pressed
            self.joystate.append(button)
        #if button == 0 :
        #elif button == 2:
        #elif button == 3:
        if button == self.joyactions['inc'] : # increase. forward in box list
            self.selected.doDeselect()
            i = self.boxList.index(self.selected) # 0 to 7
            if i >= len(self.boxList)-1 : i = -1 # wrap at 7, set it to -1
            self.selected = self.boxList[i+1] # -1+1 = 0
            self.selected.doSelect()
        elif button == self.joyactions['dec']: # decrease.  backwards in box list
            self.selected.doDeselect()
            i = self.boxList.index(self.selected) # 0 to 8
            if i == 0 : i = len(self.boxList) # wrap at 0
            self.selected = self.boxList[i-1]
            self.selected.doSelect()
        #elif button == 6:
        #elif button == 7:
        #elif button == 8:

    def joyButtonUp(self, joystick, button) :
        if button in self.joystate : # not pressed anymore
            self.joystate.remove(button)
    #   print "up button %d on joystick %d" % (button, joystick)#









class SmallBox(SRect) :
    """ Base for draggable box that controls volume and pan for each layer
    """
    def __init__(self, display, x,y,z,w,h,c) :
        SRect.__init__(self, x,y,z,w,h, c)

        self.display = display
        self.constrainRect = 0, 0, self.app.width, self.app.height
        self.oldcolor = c[0],c[1],c[2],1
        self.interactiveState = 2
        self.delta = [0,0]

        self.label = Text(str(self.z-20), self.x + 5 + self.width2, self.y+5 + self.height2, self.z,
                          'helvetica', 10, (0.2,0.2,0.2))
        
        self.looper = self.app.loopers[self.z-20] # just keep a reference to it
        self.updateLooper()
##        self.looper.pan = self.calcPan()
##        self.looper.amp = self.calcVol()

    def end(self) :
        self.label.end()
##        self.looper.free() # ???
        super(SmallBox, self).end()
        
    def rightMouseDown(self,x,y) :
        self.display.mute() # pass event to display, they both need to react
        self.mute()

    def mute(self) :
        if self.blend == 1 : #or self.getBlend() == 0 : # coz blend returns 0 if none
            self.blend = 0.3
            self.label.text = str(self.z-20)+ ' muted' # OSC #
        else:
            self.blend = 1
            self.label.text = str(self.z-20) # OSC #
        self.looper.mute = int(self.blend) #multiply by 0 or 1

    def moveLabel(self) : #, x,y) :
        self.label.loc = self.x + 5 + self.width2, self.y + 5 + self.height2

    def drag(self,x,y) :
        SRect.drag(self, x,y)
        self.moveLabel() # x,y)
        self.looper.pan = self.calcPan()
        self.looper.amp = self.calcVol()
        
    def calcPan(self) : return (self.x*(2.0/self.app.width)) -1
    def calcVol(self) :
        if not self.app.vol : return 0 # to avoid /0 when no volume
        return (((self.app.height - self.y)*(1.0 / self.app.height))) * self.app.vol

    def updateLooper(self) :
        self.looper.pan = self.calcPan()
        self.looper.amp = self.calcVol()
        self.looper.mute = int(self.blend) # multiply by 0 or 1

    def render(self,e) :
##        if glGetFloatv(GL_CURRENT_COLOR) != self.color :
        glColor4fv(self.color)
        glPushMatrix()
        glTranslatef(self.x, self.y, -self.z)
        glRectf(-self.width2, -self.height2 , self.width2, self.height2)

        # Marquee 
        glColor4fv((0,0,0,1)) # black
        glLineWidth(1)
        glBegin(GL_LINE_LOOP)
        glVertex2f(-self.width2, -self.height2)
        glVertex2f(self.width2, -self.height2)
        glVertex2f(self.width2, self.height2)
        glVertex2f(-self.width2, self.height2)
        glEnd()
        glPopMatrix()

    def mouseDown(self,x,y) :
        SRect.mouseDown(self,x,y)
        if len(Selectable.selection.selected)==1 :
            self.doSelect()

    def mouseUp(self,x,y) :
        SRect.mouseUp(self,x,y)
        if len(Selectable.selection.selected)==1 : #and not Selectable.selection.selected.index(self) : # from tools module
            self.doDeselect()

    def doSelect(self) :
        self.color = 1,0,0 # mark as red when selected
        self.display.color = self.color
        self.display.selected = 1

    def doDeselect(self) :
        self.color = self.oldcolor
        self.display.color = self.display.oldcolor
        self.display.selected = 0
        self.delta = [0,0]




class MovingSmallBox(SmallBox) :
    """ draggable box that wanders around
        max step possible / limiting factor
    """
    def __init__(self, display, x,y,z,w,h,c) :
        SmallBox.__init__(self, display, x,y,z,w,h, c) #
        self.timeOut = self.doTimeOut()
        self.delta = self.calcDelta()
        self.constrainRect = 0, 0, self.app.size[0], self.app.size[1]

    def step(self) :
        if self.app.boxStep : 
            self.checkTimeOut()
##            self.x += self.delta[0]
##            self.y += self.delta[1]
            self.loc = constrainToRect( (self.x + self.delta[0]) , (self.y + self.delta[1]) , self.constrainRect )
            if self.x >= self.app.width or self.x <= 0 : self.delta[0] *= -1
            if self.y >= self.app.height or self.y <= 0 : self.delta[1] *= -1
            self.moveLabel() # self.x, self.y
            self.looper.pan = self.calcPan()
            self.looper.amp = self.calcVol()

    def doTimeOut(self) :
        return time.time() + utilities.randint(60, 120) #secs

    def checkTimeOut(self) :
        if time.time() >= self.timeOut :
            self.delta = self.calcDelta()
            self.timeOut = self.doTimeOut() # again

    def calcDelta(self) :
##        deltax = deltay = 0
##        while deltax == 0 : deltax = utilities.randint(-self.app.boxStep, self.app.boxStep) *(self.app.boxspeed/10.0)
##        while deltay == 0 : deltay = utilities.randint(-self.app.boxStep, self.app.boxStep) * (self.app.boxspeed/10.0)
##        while deltax == 0 : deltax = utilities.choice((-1, 1)) * (self.app.boxspeed/10.0)
##        while deltay == 0 : deltay = utilities.choice((-1, 1)) * (self.app.boxspeed/10.0)
        deltax = utilities.choice((-self.app.boxStep, self.app.boxStep)) / 20.0
        deltay = utilities.choice((-self.app.boxStep, self.app.boxStep)) / 20.0
        return [ deltax, deltay ] # needs to be an array because it changes individually






class HandleBase(Rect) :
    """ base for handles, dragable rect that controls displays with its loc.
    it is connected to each smallbox with a line
    """
    def __init__(self, x,y,z,w,h, displayList=[], boxList=[], color=(0,0,0)) :
        self.boxList = boxList
        self.displayList = displayList
        Rect.__init__(self, x,y,z,w,h, color) # super
        self.interactiveState = 2 #
        self.updateDisplays()
        self.constrainRect = 0, 0, self.app.width, self.app.height

    def render(self,e) :
        glPushMatrix()
        glTranslatef(self.x, self.y, -self.z)
        # colored box #
        glColor4fv(self.color)
        try :
            glRectfv(self.v2[0], self.v2[2])
        except: # pyopengl3 bug 
            glBegin(GL_QUADS)
            glVertex2fv(self.v2[0])
            glVertex2fv(self.v2[1])
            glVertex2fv(self.v2[2])
            glVertex2fv(self.v2[3])
            glEnd()
##            print 'render error on HandleBase render'
        # Marquee starts #
        glColor4fv((0,0,0,1)) # black
        glLineWidth(1)
        glBegin(GL_LINE_LOOP)
        glVertex2fv(self.v2[0])
        glVertex2fv(self.v2[1])
        glVertex2fv(self.v2[2])
        glVertex2fv(self.v2[3])
        glEnd()
        glPopMatrix()
        # lines #
##        glLineWidth(1)
        glColor4fv(self.color)
        for b in self.boxList :
            x = abs(self.x + (b.x - self.x) * 0.5) # calc loc point
            y = abs(self.y + (b.y - self.y) * 0.5) 
            
            glPushMatrix()
            glTranslatef(x, y, -self.z) # translate to GL loc ppint
            glBegin(GL_LINES)
            glVertex2f( x - self.x,  y - self.y) # draw relative pixel points
            glVertex2f(x - b.x,  y - b.y)
            glEnd()
            glPopMatrix()   

    def drag(self,x,y) :
        Rect.drag(self, x, y) # super
        self.updateDisplays() # if dragged

    def updateDisplays(self) :
        for d in self.displayList :
            d.update()#self.x, self.y)







class BlackHandle(HandleBase) :
    def __init__(self, x,y,z,w,h, displayList=[], boxList=[], color=(0,0,0)) :
        self.rev = self.app.height*0.5 # to reverse values from mouseY
        super(BlackHandle, self).__init__(x,y,z,w,h, displayList, boxList, color)

    def updateDisplays(self) :
        self.app.grain = self.x
        self.setPitch(self.y) # +1) # plus 1 to avoid 0
        super(BlackHandle,self).updateDisplays()

    def setPitch(self, i) :
        if i < self.app.height*0.5 : # top. mouse range 0 to middle 300
            if i == 0 : # very top'
                self.app.pitch = self.app.pitchLimits[0] # fix float rounding problem
            else:
                self.app.pitch = self.app.pitchLimits[1] + ( self.app.pitchLimits[3] * abs(self.rev - i) ) # scale to mid to max
        elif i == self.app.height*0.5 :# middle
            self.app.pitch = self.app.pitchLimits[1]
        else : # bottom. the difference is that mouse range is 300 to 600 here
##            self.app.pitch = self.app.pitchLimits[1] - (self.app.pitchLimits[1] - ( self.app.pitchLimits[4] * abs(self.app.size[1] - i) ) )
            self.app.pitch = self.app.pitchLimits[2] + ( self.app.pitchLimits[4] * abs(self.app.height - i) )

        if not self.app.microtones :
            self.app.pitch = int(self.app.pitch)
        else :
            self.app.pitch = round(self.app.pitch, 4) # four digits
        
        for l in self.app.loopers : l.rate = self.app.pitch # SEND PITCH

    def drag(self, x, y) :
        if self.app.freedom[ 'pitch' ] : # y unlocked
            self.loc = constrainToRect( self.x, y + self.mouseoffset[1], self.constrainRect )
        if self.app.freedom[ 'length' ] : # x unlocked
            self.loc = constrainToRect( x + self.mouseoffset[0], self.y, self.constrainRect)
            
        self.updateDisplays() # if dragged
        
    ###################################
##    def jumpY(self) :
##        self.y = utilities.randint(0, self.app.size[1])##        self.updateDisplays() # if dragged
##        self.updateLabel()
##
##    def step(self) :
##        if time.time() >= self.timeOut:
##            self.jumpY()
##            self.timeOut = self.doTimeOut() # again
##
##    def doTimeOut(self) :
##        return time.time()+ utilities.randint(240, 360) # 120, 240) # 4 to 6 min








class WhiteHandle(HandleBase) :
    """ special handle that jumps once in a while to a close new loc
    """
    def __init__(self, x,y,z,w,h, displayList=[], boxList=[], color=(0,0,0)) :
        super(WhiteHandle, self).__init__(x,y,z,w,h, displayList, boxList, color)
        self.constrainRect = 0, 0, self.app.width, self.app.height

    def updateDisplays(self) :
        self.app.sttime = self.x
        self.app.shift = int( (self.y - self.app.height*0.5) / 1.33) # limit it a bit
        super(WhiteHandle, self).updateDisplays()

    def start(self) :
        self.timeOut = self.doTimeOut()
        self.delta = self.calcDelta()

    def doTimeOut(self) :
        return time.time()+ utilities.randint(120, 240) # 120, 240) # 2 to 4 min

    def step(self) :
        if self.app.autoNodes : 
            if time.time() >= self.timeOut :
                self.x += self.delta[0]
                self.y += self.delta[1]
                if self.x >= self.app.width or self.x <= 0 : self.delta[0] *= -1
                if self.y >= self.app.height or self.y <= 0 : self.delta[1] *= -1
                self.updateDisplays() # if dragged
                self.timeOut = self.doTimeOut() # again

    def calcDelta(self) :
        deltax = deltay = 0
        i = 4 # max step
        while deltax == 0 : deltax = utilities.randint(-i, i)#/300.0
        while deltay == 0 : deltay = utilities.randint(-i, i)#/300.0
        return [deltax, deltay] # needs to be an array because it changes
    

    def drag(self,x,y) :
        if self.app.freedom[ 'shift' ] : # y unlocked
            self.loc = constrainToRect( self.x, y + self.mouseoffset[1] , self.constrainRect)
        if self.app.freedom[ 'start' ] : # x unlocked
            self.loc = constrainToRect( x + self.mouseoffset[0], self.y , self.constrainRect)

        self.updateDisplays() # if dragged







class Display(Rect) :
    """ long rect that displays the lenght of selected sample that corresponds to its layer of sound
    """
    def __init__(self, x,y,z,w,h,forecolor) :#bgcolor,forecolor) :
        Rect.__init__(self, x,y,z,w,h, stroke=1)
        self.interactiveState = 1 # mouseable
        self.forecolor = forecolor[0],forecolor[1],forecolor[2],1
        self.color = 0.4, 0.4, 0.4, 1 # marquee color
        self.oldcolor = self.color
        self.limits = [0, self.width]
        self.selected = 0

##        self.q = utilities.calcRelativeVertex(x,y, utilities.calcRectQuad(x,y,w,h))
        font = 10 # font size
        labelx = 3 + self.x - self.width2
        labely = self.y + (self.height2) - 2
        self.label = Text('dummytext', labelx, labely, self.z+1, 'helvetica', font, (0.2,0.2,0.2))
        self.num = Text(str(z), labelx, (self.y-self.height2+font+2), self.z+1, 'helvetica', font, (0.2,0.2,0.2)) # number, doesnt change

        self.mybox = 0 # to store ref to box where i am related to
        self.playhead = self.x - self.width2 # left position

        # compile call list  	 
        glNewList(self.z+1, GL_COMPILE) # unique int id for each list 	 
        glColor4fv(self.color) # black? 	 
        glPushMatrix() 	 
        glTranslatef(self.x, self.y, -self.z) # translate to GL loc ppint 	 
        glLineWidth(1) 	 
        glBegin(GL_LINE_LOOP) 	 
        glVertex2f(-self.width2, -self.height2) 	 
        glVertex2f(self.width2, -self.height2) 	 
        glVertex2f(self.width2, self.height2) 	 
        glVertex2f(-self.width2, self.height2) 	 
        glEnd() 	 
        glPopMatrix() 	 
        glEndList()
        

    def end(self) : # extending end
        self.label.end()
        self.num.end()
        glDeleteLists( self.z+1, 1)
        super(Display, self).end() #

    def update(self) :#, x,y) :
        """ update selected area, check for limits
        """
        mysttime = self.app.sttime + self.z * self.app.shift
        myendtime = mysttime + self.app.grain
        # it does work but took me time ...
        if mysttime > self.width: # wrap on right
            mysttime = mysttime % self.width
            myendtime = mysttime + self.app.grain
            if myendtime > self.width : # cut on right
                myendtime = self.width
        elif myendtime > self.width : # cut on right
            myendtime = self.width
        elif myendtime < 0: # wrap on left
            mysttime = self.width - (-mysttime % self.width) # positive modulo from right
            myendtime = mysttime + self.app.grain
            if myendtime > self.width : # cut on right
                myendtime = self.width
        elif mysttime < 0 : #cut on left
            mysttime = 0
            
        if mysttime == myendtime : myendtime = mysttime+1
        
        self.limits = mysttime, myendtime
        self.app.loopers[self.z].start, self.app.loopers[self.z].end = self.calcLimits()
        self.label.text = '%f : %f' % (self.app.loopers[self.z].start, self.app.loopers[self.z].end) # start and end point

    def calcLimits(self) :
        v = 1.0/self.width # from 0 to 1 per pixel
        return self.limits[0]*v, self.limits[1]*v #l # start and end of slice

    
    def render(self,e) :       
        bgleft = self.x - self.width2  # display's marquee left side
        w = (self.limits[1] - self.limits[0] + 1)*0.5 # half width of color area
        x = bgleft + self.limits[0] + w # x loc of color rect
        
        # colored selection area
        glColor4fv(self.forecolor) # black? 
        glPushMatrix()
        glTranslatef(x, self.y, -self.z) # translate to GL loc ppint
        glRectf(-w, -self.height2, w, self.height2)
        glPopMatrix()

        # marquee
        glCallList(self.z+1)
        
        # playhead line
        glColor4fv((1,0,0,1)) # red
        glPushMatrix()
        glTranslatef(self.playhead, self.y, -self.z) # translate to GL loc ppint
        glLineWidth(1)
        glBegin(GL_LINES)
        glVertex2f(0, self.height2) # line ends
        glVertex2f(0, -self.height2)
        glEnd()
        glPopMatrix()
        
        # red mark # already drawing red at this point
        if self.selected : # mark as selected
            glPushMatrix()
            glTranslatef(20, self.y, -self.z)
            glRectf(-7,-7,7,7)
            glPopMatrix()


    def updateLabel(self) :
        self.label.text = '%f : %f' % self.calcLimits() # start and end point

    def rightMouseDown(self,x,y) :
        self.mybox.mute() # small box too
        self.mute() #

    def mouseDown(self,x,y) : return -1 # pass event to background
    def mouseUp(self,x,y) : return -1 # pass event to background

    def mute(self) :
        if self.blend == 1 : #or self.getBlend() == 0 : # coz blend returns 0 if none
            self.blend = 0.3
            self.forecolor = self.forecolor[0], self.forecolor[1], self.forecolor[2], self.blend
        else:
            self.blend = 1
            self.forecolor = self.forecolor[0], self.forecolor[1], self.forecolor[2], self.blend

    def setplayhead(self, f) : # range 0 to 1 # left side + position in sound * how many px is the sound
        self.playhead = (self.x-self.width2) + f * self.width    #

    def reset(self) :
        pass
##        self.playhead = self.limits[0] # left selection border
        ## here i need to send the looper to the current left limit
        ## phasor needs to be reseted in supercollider for this to happen
##        self.app.loopers[self.z].pos = 0









        

        
        
class Looper(sc.Synth) :
    def __init__(self, synthname, bus, buffer, amp = 0, pan = 0, mute = 1, start = 0, end = 1, rate = 1) :
        """ s_new args : stringdefname, synth ID (bus), addaction, addtargetID, args:[controlindexorname, control value]
        """
        super(Looper, self).__init__(synthname, bus)
        
        self.buffer = buffer
        self.amp = amp
        self.pan = pan
        self.mute = mute
        self.start = start
        self.end = end
        self.rate = rate









if __name__ == '__main__': Slicer() # init always your main app class that extends main.App
