/* plays stereo sound files. 
sends  /tr labeled OSC messages with current position in buffer fps times per sec
amplitude 0 to 1, pan -1 to 1. start/end 0 to 1
www.ixi-software.net
- to do:
reset to start point (to specific point?)
send buffer length on sample load
remove loop clicks
*/

(
SynthDef ( "StereoPlayer" , { 
	arg bus=0, buffer=0, amp=1, pan=0, mute=1, start=0, end=1, rate=1, fps=12; //, trig=1, resetpos=0;
    	var length, offset, clock, env, sound, left, right, phasor, dur;

	dur = BufFrames.kr(buffer);
    	length = (end - start) * dur; // scale from range 0 - 1 to 0 - buflength
    	//SendTrig.kr(LFPulse.kr(12, 0), 666666, dur); // send buffer length in samples
    	clock = LFPulse.kr(rate.abs / length, 0); // loop
    	length = Latch.kr(length, clock);
    	offset = Latch.kr(start *dur, clock);
    	env = EnvGen.kr( Env .new([0,1,1,0], [0.01, 0.98,0.01]), clock, timeScale:length /(rate.abs)) * amp * mute;
	
	//var trig_;
	//trig_ = Impulse.ar(trig);
   	//phasor = Phasor.ar( trig_, rate, start*dur, end*dur, resetpos ); // trig, rate, start, end, resetPos	
	phasor = Phasor.ar( 0, rate, start*dur, end*dur);
    	SendTrig .kr( LFPulse.kr(fps, 0), bus, phasor/dur); //12 times per sec playhead. Normalised to 0-1 range
    	#left, right = BufRd.ar( 2, buffer, phasor, 1 ) * env;
    	Out .ar(bus, Balance2.ar(left, right, pan));
}).load(s)
)


b = Buffer.read(s, "/home/r2d2/.sc/sounds/numeros.wav");
b.postln;
a = Synth ( \StereoPlayer , [ \buffer , b.bufnum, \end ,1000]);
a.set(\start,0.1);
a.set(\end, 0.5);
// trig and resetpos dont seem to do anything now!
a.set(\trig, 1); // controls the loop length with number. I dont want this, i need to send bang to reset sample 
a.set(\resetpos, 0.1); 
a.free;
